#!/bin/bash
# Linux Updater of the StargateTC 2  mod( www.stargatetc2.com )
# Version 0.2 By Wolfox, English translation by Raton

# Parameters : -debug , -dir to give the download directory (default directory = script directory)
# -update to re-download from a given update, -unofficial for the non official content

getInfoXML()
{
	#The required info is read in the required line and the Return instruction is deleted.
	echo -n `grep package unofficial.xml | sed "s/<\/$1>/%/" | cut -d'%' -f1 | sed "s/<$1>/%/" | cut -d'%' -f2 | awk "NR == (($2+1)) {print;}"`
}

echo
echo "Welcome in the console updater of the StargateTC 2 mod! ( www.stargatetc2.com )"
echo

rep="."
updateLocale=0
silence="-q"
mode="updater"

#Parameters check

while [ $# != 0 ] ; do
	if [ "$1" = "-dir" ] ; then
	{
		
		if [ -d "$2" ] ; then
		{
			rep=$2
		}
		else
		{
			echo "The directory given as input doesn't exist."
			exit 4
		}
		fi
	}
	elif [ "$1" = "-update" ] ; then
	{
		updateLocale=$2
		rm -f updates.txt
	}
	elif [ "$1" = "-debug" ] ; then
	{
		silence=""
	}
	elif [ "$1" = "-unofficial" ] ; then
	{
		mode="unofficial"
	}
	elif [ "$1" = "-h" ] ; then
	{
		echo "StargateTC 2 Updater, a tool to keep the Linux server version of the StargateTC 2 mod up to date."
		echo
		echo "The input parameters are as follow :"
		echo
		echo "-h for memory help"
		echo "-debug to display the detailled operation log"		
		echo "-dir X to set the download repertory of the updates (the current directory is used by default)"
		echo "-update X to re-download the updates from the update nr X"
		echo "-unofficial to re-download the community-made work"
		echo
		echo "This script requires unzip to be installed, among other tools."
		echo
		exit 0;
	}	
	fi

	shift #input parameters shift
done

if [ $mode = "updater" ] ; then
{
	if [ -e "updates.txt" ] ; then
	{
		updateLocale=`cat updates.txt`
	}
	fi

	echo "The local update is $updateLocale."
	echo
	echo "Looking for new updates..."

	wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getMaintenance" -O "status.txt"
	if [ "`cat status.txt`" != "off" ] ; then
	{
		echo "The server seems to be under maintenance. Wait a couple of minutes before running this updater again."
		echo "If the problem persists, please ask for help on ww.stargatetc2.com"
	}
	fi
	rm -f "status.txt"


	#Getting the number of the last update
	wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getVersion" -O "updatesonline.txt"

	if [ $? != 0 ] ; then
	{
		echo "Check error of the last update."
		exit 3
	}
	fi

	updateActuelle=`cat updatesonline.txt`
	rm -f "updatesonline.txt"

	echo "The current update number is : $updateActuelle"
	echo


	if [ $updateLocale = $updateActuelle ] ; then
	{
		echo "No new update available."
		echo
		exit 0
	}
	fi


	# Mirror search
	wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getMirroirPrincipale" -O "miroir.txt"
	miroir=`cat miroir.txt`
	rm -f "miroir.txt"

	# Taille totale des updates à faire :
	
	wget $silence "http://stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getTaille&version=$updateLocale" -O "taille.txt"
	total=`cat taille.txt`

	# Updates download

	while [ $updateLocale -lt $updateActuelle ] ; do
		let "updateLocale++"

		wget $silence "http://stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getTaille&version=$((updateLocale-1))" -O "taille.txt"
		taille=`cat taille.txt`

		let "pourcentage=100-(taille*100/total)"

		fichierUpdate="update_$updateLocale.zip"
	
		lien="${miroir}package_sgtc2/$fichierUpdate"

		echo "Downloading the update $updateLocale. (Total progress : ${pourcentage}%)"
		wget $silence $lien -O "$rep/$fichierUpdate"

		if [ $? != 0 ] ; then
		{
			echo "Download error. Please try again later."
			rm -f "$rep/$fichierUpdate"
			exit 1
		}
		fi

		echo "Download completed. Unzipping..."
		unzip -u $silence "$rep/$fichierUpdate" -d "$rep"

		if [ $? != 0 ] ; then
		{
			echo "Unzip error"
			exit 2
		}
		fi

		#Check of the files to be deleted
		wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getFichiersEffacer&version=$updateLocale" -O "listeSuppr.txt"

		grep fichier listeSuppr.txt | sed 's/\\/\//g' | sed "s/<fichier>//" | sed "s/<\/fichier>//" | sed "s/<repertoire>\///" | sed "s/<\/repertoire>//" | sed "s/<nom>//" | sed "s/<\/nom>//" > listeSuppr.txt
		rm -f `cat listeSuppr.txt`

		rm -f "$rep/$fichierUpdate" "listeSuppr.txt"
		echo "Update $updateLocale completed."
	
	done

	echo -n "$updateLocale" > updates.txt #save of the update number

	echo
	echo "Update completed !"
}
elif [ $mode = "unofficial" ] ; then
{
	echo "List of the available unofficial content :"
	echo

	wget $silence "http://www.stargatetc2.com/updater_sgtc2/comm.php?machine=serveur&action=getPackages&langue=en" -O "unofficial.xml"
	if [ $? != 0 ] ; then
	{
		echo "Error of list retrieval. Please try again later. If the problem persists, please ask for help on www.stargatetc2.com ."
		exit 1
	}
	fi

	#number of info lines of the xml file :
	lignes=`grep package unofficial.xml | sed "s/<\/$1>/%/" | cut -d'%' -f1 | sed "s/<$1>/%/" | cut -d'%' -f2 | awk 'END {print NR}'`
	
	#displays type" 1- Map sg_gnu : a gnu map (by Chuck Norris, version 42). "
	i=0
	while [ $i -lt $lignes ] ; do
		
		let "numero=i+1"
		echo -n "$numero- "
		getInfoXML "type" $i
		echo -n " "
		getInfoXML "nomMap" $i
		echo -n " : "
		getInfoXML "description" $i
		echo -n " (by "
		getInfoXML "auteur" $i
		echo -n ", version "
		getInfoXML "version" $i		
		echo -n "). Mark : "
		getInfoXML "note" $i
		echo "/5."
		let "i++"		
	done

	echo

	let "choix=lignes+1"
	while [ $choix -gt $lignes  ] || [ $choix -lt 1 ] ; do
		echo -n "Your choice ? "
		read choix
	done

	echo "Download of the chosen content..."
	wget $silence `getInfoXML "urlDownload" $((choix-1))` -O "$rep/unofficial.zip"
	if [ $? != 0 ] ; then
	{
		echo "Download error. Please try again later."
		rm -f "$rep/unofficial.zip"
		exit 1
	}
	fi
	echo "Download completed. Unzipping..."

	unzip -u $silence "$rep/unofficial.zip" -d "$rep"
	if [ $? != 0 ] ; then
	{
		echo "Unzip error"
		exit 2
	}
	fi

	rm -f "$rep/unofficial.zip"

	echo "Content installed !"
}
fi

echo

exit 0
